<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Walletobjects;

class LatLongPoint extends \Google\Model
{
  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#latLongPoint"`.
   *
   * @deprecated
   * @var string
   */
  public $kind;
  /**
   * The latitude specified as any value in the range of -90.0 through +90.0,
   * both inclusive. Values outside these bounds will be rejected.
   *
   * @var 
   */
  public $latitude;
  /**
   * The longitude specified in the range -180.0 through +180.0, both inclusive.
   * Values outside these bounds will be rejected.
   *
   * @var 
   */
  public $longitude;

  /**
   * Identifies what kind of resource this is. Value: the fixed string
   * `"walletobjects#latLongPoint"`.
   *
   * @deprecated
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @deprecated
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  public function setLatitude($latitude)
  {
    $this->latitude = $latitude;
  }
  public function getLatitude()
  {
    return $this->latitude;
  }
  public function setLongitude($longitude)
  {
    $this->longitude = $longitude;
  }
  public function getLongitude()
  {
    return $this->longitude;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(LatLongPoint::class, 'Google_Service_Walletobjects_LatLongPoint');
