<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Translate;

class GcsDestination extends \Google\Model
{
  /**
   * Required. The bucket used in 'output_uri_prefix' must exist and there must
   * be no files under 'output_uri_prefix'. 'output_uri_prefix' must end with
   * "/" and start with "gs://". One 'output_uri_prefix' can only be used by one
   * batch translation job at a time. Otherwise an INVALID_ARGUMENT (400) error
   * is returned.
   *
   * @var string
   */
  public $outputUriPrefix;

  /**
   * Required. The bucket used in 'output_uri_prefix' must exist and there must
   * be no files under 'output_uri_prefix'. 'output_uri_prefix' must end with
   * "/" and start with "gs://". One 'output_uri_prefix' can only be used by one
   * batch translation job at a time. Otherwise an INVALID_ARGUMENT (400) error
   * is returned.
   *
   * @param string $outputUriPrefix
   */
  public function setOutputUriPrefix($outputUriPrefix)
  {
    $this->outputUriPrefix = $outputUriPrefix;
  }
  /**
   * @return string
   */
  public function getOutputUriPrefix()
  {
    return $this->outputUriPrefix;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GcsDestination::class, 'Google_Service_Translate_GcsDestination');
