<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\TrafficDirectorService;

class PerXdsConfig extends \Google\Model
{
  /**
   * Config status is not available/unknown.
   */
  public const CLIENT_STATUS_CLIENT_UNKNOWN = 'CLIENT_UNKNOWN';
  /**
   * Client requested the config but hasn't received any config from management
   * server yet.
   */
  public const CLIENT_STATUS_CLIENT_REQUESTED = 'CLIENT_REQUESTED';
  /**
   * Client received the config and replied with ACK.
   */
  public const CLIENT_STATUS_CLIENT_ACKED = 'CLIENT_ACKED';
  /**
   * Client received the config and replied with NACK. Notably, the attached
   * config dump is not the NACKed version, but the most recent accepted one. If
   * no config is accepted yet, the attached config dump will be empty.
   */
  public const CLIENT_STATUS_CLIENT_NACKED = 'CLIENT_NACKED';
  /**
   * Client received an error from the control plane. The attached config dump
   * is the most recent accepted one. If no config is accepted yet, the attached
   * config dump will be empty.
   */
  public const CLIENT_STATUS_CLIENT_RECEIVED_ERROR = 'CLIENT_RECEIVED_ERROR';
  /**
   * Status info is not available/unknown.
   */
  public const STATUS_UNKNOWN = 'UNKNOWN';
  /**
   * Management server has sent the config to client and received ACK.
   */
  public const STATUS_SYNCED = 'SYNCED';
  /**
   * Config is not sent.
   */
  public const STATUS_NOT_SENT = 'NOT_SENT';
  /**
   * Management server has sent the config to client but hasn’t received
   * ACK/NACK.
   */
  public const STATUS_STALE = 'STALE';
  /**
   * Management server has sent the config to client but received NACK. The
   * attached config dump will be the latest config (the rejected one), since it
   * is the persisted version in the management server.
   */
  public const STATUS_ERROR = 'ERROR';
  /**
   * Client config status is populated by xDS clients. Will not be present if
   * the CSDS server is an xDS server. No matter what the client config status
   * is, xDS clients should always dump the most recent accepted xDS config. ..
   * attention:: This field is deprecated. Use :ref:`ClientResourceStatus ` for
   * per-resource config status instead.
   *
   * @deprecated
   * @var string
   */
  public $clientStatus;
  protected $clusterConfigType = ClustersConfigDump::class;
  protected $clusterConfigDataType = '';
  protected $endpointConfigType = EndpointsConfigDump::class;
  protected $endpointConfigDataType = '';
  protected $listenerConfigType = ListenersConfigDump::class;
  protected $listenerConfigDataType = '';
  protected $routeConfigType = RoutesConfigDump::class;
  protected $routeConfigDataType = '';
  protected $scopedRouteConfigType = ScopedRoutesConfigDump::class;
  protected $scopedRouteConfigDataType = '';
  /**
   * Config status generated by management servers. Will not be present if the
   * CSDS server is an xDS client.
   *
   * @var string
   */
  public $status;

  /**
   * Client config status is populated by xDS clients. Will not be present if
   * the CSDS server is an xDS server. No matter what the client config status
   * is, xDS clients should always dump the most recent accepted xDS config. ..
   * attention:: This field is deprecated. Use :ref:`ClientResourceStatus ` for
   * per-resource config status instead.
   *
   * Accepted values: CLIENT_UNKNOWN, CLIENT_REQUESTED, CLIENT_ACKED,
   * CLIENT_NACKED, CLIENT_RECEIVED_ERROR
   *
   * @deprecated
   * @param self::CLIENT_STATUS_* $clientStatus
   */
  public function setClientStatus($clientStatus)
  {
    $this->clientStatus = $clientStatus;
  }
  /**
   * @deprecated
   * @return self::CLIENT_STATUS_*
   */
  public function getClientStatus()
  {
    return $this->clientStatus;
  }
  /**
   * @param ClustersConfigDump $clusterConfig
   */
  public function setClusterConfig(ClustersConfigDump $clusterConfig)
  {
    $this->clusterConfig = $clusterConfig;
  }
  /**
   * @return ClustersConfigDump
   */
  public function getClusterConfig()
  {
    return $this->clusterConfig;
  }
  /**
   * @param EndpointsConfigDump $endpointConfig
   */
  public function setEndpointConfig(EndpointsConfigDump $endpointConfig)
  {
    $this->endpointConfig = $endpointConfig;
  }
  /**
   * @return EndpointsConfigDump
   */
  public function getEndpointConfig()
  {
    return $this->endpointConfig;
  }
  /**
   * @param ListenersConfigDump $listenerConfig
   */
  public function setListenerConfig(ListenersConfigDump $listenerConfig)
  {
    $this->listenerConfig = $listenerConfig;
  }
  /**
   * @return ListenersConfigDump
   */
  public function getListenerConfig()
  {
    return $this->listenerConfig;
  }
  /**
   * @param RoutesConfigDump $routeConfig
   */
  public function setRouteConfig(RoutesConfigDump $routeConfig)
  {
    $this->routeConfig = $routeConfig;
  }
  /**
   * @return RoutesConfigDump
   */
  public function getRouteConfig()
  {
    return $this->routeConfig;
  }
  /**
   * @param ScopedRoutesConfigDump $scopedRouteConfig
   */
  public function setScopedRouteConfig(ScopedRoutesConfigDump $scopedRouteConfig)
  {
    $this->scopedRouteConfig = $scopedRouteConfig;
  }
  /**
   * @return ScopedRoutesConfigDump
   */
  public function getScopedRouteConfig()
  {
    return $this->scopedRouteConfig;
  }
  /**
   * Config status generated by management servers. Will not be present if the
   * CSDS server is an xDS client.
   *
   * Accepted values: UNKNOWN, SYNCED, NOT_SENT, STALE, ERROR
   *
   * @param self::STATUS_* $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return self::STATUS_*
   */
  public function getStatus()
  {
    return $this->status;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PerXdsConfig::class, 'Google_Service_TrafficDirectorService_PerXdsConfig');
