<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ToolResults;

class ListStepsResponse extends \Google\Collection
{
  protected $collection_key = 'steps';
  /**
   * A continuation token to resume the query at the next item. If set,
   * indicates that there are more steps to read, by calling list again with
   * this value in the page_token field.
   *
   * @var string
   */
  public $nextPageToken;
  protected $stepsType = Step::class;
  protected $stepsDataType = 'array';

  /**
   * A continuation token to resume the query at the next item. If set,
   * indicates that there are more steps to read, by calling list again with
   * this value in the page_token field.
   *
   * @param string $nextPageToken
   */
  public function setNextPageToken($nextPageToken)
  {
    $this->nextPageToken = $nextPageToken;
  }
  /**
   * @return string
   */
  public function getNextPageToken()
  {
    return $this->nextPageToken;
  }
  /**
   * Steps.
   *
   * @param Step[] $steps
   */
  public function setSteps($steps)
  {
    $this->steps = $steps;
  }
  /**
   * @return Step[]
   */
  public function getSteps()
  {
    return $this->steps;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(ListStepsResponse::class, 'Google_Service_ToolResults_ListStepsResponse');
