<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class PaymentServiceProviderLinkInfo extends \Google\Model
{
  /**
   * The business country of the merchant account as identified by the third
   * party service provider.
   *
   * @var string
   */
  public $externalAccountBusinessCountry;
  /**
   * The id used by the third party service provider to identify the merchant.
   *
   * @var string
   */
  public $externalAccountId;

  /**
   * The business country of the merchant account as identified by the third
   * party service provider.
   *
   * @param string $externalAccountBusinessCountry
   */
  public function setExternalAccountBusinessCountry($externalAccountBusinessCountry)
  {
    $this->externalAccountBusinessCountry = $externalAccountBusinessCountry;
  }
  /**
   * @return string
   */
  public function getExternalAccountBusinessCountry()
  {
    return $this->externalAccountBusinessCountry;
  }
  /**
   * The id used by the third party service provider to identify the merchant.
   *
   * @param string $externalAccountId
   */
  public function setExternalAccountId($externalAccountId)
  {
    $this->externalAccountId = $externalAccountId;
  }
  /**
   * @return string
   */
  public function getExternalAccountId()
  {
    return $this->externalAccountId;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(PaymentServiceProviderLinkInfo::class, 'Google_Service_ShoppingContent_PaymentServiceProviderLinkInfo');
