<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\ShoppingContent;

class GmbAccountsGmbAccount extends \Google\Model
{
  /**
   * The email which identifies the Business Profile.
   *
   * @var string
   */
  public $email;
  /**
   * Number of listings under this account.
   *
   * @var string
   */
  public $listingCount;
  /**
   * The name of the Business Profile.
   *
   * @var string
   */
  public $name;
  /**
   * The type of the Business Profile (User or Business).
   *
   * @var string
   */
  public $type;

  /**
   * The email which identifies the Business Profile.
   *
   * @param string $email
   */
  public function setEmail($email)
  {
    $this->email = $email;
  }
  /**
   * @return string
   */
  public function getEmail()
  {
    return $this->email;
  }
  /**
   * Number of listings under this account.
   *
   * @param string $listingCount
   */
  public function setListingCount($listingCount)
  {
    $this->listingCount = $listingCount;
  }
  /**
   * @return string
   */
  public function getListingCount()
  {
    return $this->listingCount;
  }
  /**
   * The name of the Business Profile.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * The type of the Business Profile (User or Business).
   *
   * @param string $type
   */
  public function setType($type)
  {
    $this->type = $type;
  }
  /**
   * @return string
   */
  public function getType()
  {
    return $this->type;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GmbAccountsGmbAccount::class, 'Google_Service_ShoppingContent_GmbAccountsGmbAccount');
