<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Reseller;

class Subscription extends \Google\Collection
{
  protected $collection_key = 'suspensionReasons';
  /**
   * Read-only field that returns the current billing method for a subscription.
   *
   * @var string
   */
  public $billingMethod;
  /**
   * The `creationTime` property is the date when subscription was created. It
   * is in milliseconds using the Epoch format. See an example Epoch converter.
   *
   * @var string
   */
  public $creationTime;
  /**
   * Primary domain name of the customer
   *
   * @var string
   */
  public $customerDomain;
  /**
   * This property will always be returned in a response as the unique
   * identifier generated by Google. In a request, this property can be either
   * the primary domain or the unique identifier generated by Google.
   *
   * @var string
   */
  public $customerId;
  /**
   * Google-issued code (100 char max) for discounted pricing on subscription
   * plans. Deal code must be included in `insert` requests in order to receive
   * discounted rate. This property is optional, regular pricing applies if left
   * empty.
   *
   * @var string
   */
  public $dealCode;
  /**
   * Identifies the resource as a Subscription. Value: `reseller#subscription`
   *
   * @var string
   */
  public $kind;
  protected $planType = SubscriptionPlan::class;
  protected $planDataType = '';
  /**
   * This is an optional property. This purchase order (PO) information is for
   * resellers to use for their company tracking usage. If a `purchaseOrderId`
   * value is given it appears in the API responses and shows up in the invoice.
   * The property accepts up to 80 plain text characters.
   *
   * @var string
   */
  public $purchaseOrderId;
  protected $renewalSettingsType = RenewalSettings::class;
  protected $renewalSettingsDataType = '';
  /**
   * URL to customer's Subscriptions page in the Admin console. The read-only
   * URL is generated by the API service. This is used if your client
   * application requires the customer to complete a task using the
   * Subscriptions page in the Admin console.
   *
   * @var string
   */
  public $resourceUiUrl;
  protected $seatsType = Seats::class;
  protected $seatsDataType = '';
  /**
   * A required property. The `skuId` is a unique system identifier for a
   * product's SKU assigned to a customer in the subscription. For products and
   * SKUs available in this version of the API, see Product and SKU IDs.
   *
   * @var string
   */
  public $skuId;
  /**
   * Read-only external display name for a product's SKU assigned to a customer
   * in the subscription. SKU names are subject to change at Google's
   * discretion. For products and SKUs available in this version of the API, see
   * Product and SKU IDs.
   *
   * @var string
   */
  public $skuName;
  /**
   * This is an optional property.
   *
   * @var string
   */
  public $status;
  /**
   * The `subscriptionId` is the subscription identifier and is unique for each
   * customer. This is a required property. Since a `subscriptionId` changes
   * when a subscription is updated, we recommend not using this ID as a key for
   * persistent data. Use the `subscriptionId` as described in retrieve all
   * reseller subscriptions.
   *
   * @var string
   */
  public $subscriptionId;
  /**
   * Read-only field containing an enumerable of all the current suspension
   * reasons for a subscription. It is possible for a subscription to have many
   * concurrent, overlapping suspension reasons. A subscription's `STATUS` is
   * `SUSPENDED` until all pending suspensions are removed. Possible options
   * include: - `PENDING_TOS_ACCEPTANCE` - The customer has not logged in and
   * accepted the G Suite Resold Terms of Services. - `RENEWAL_WITH_TYPE_CANCEL`
   * - The customer's commitment ended and their service was cancelled at the
   * end of their term. - `RESELLER_INITIATED` - A manual suspension invoked by
   * a Reseller. - `TRIAL_ENDED` - The customer's trial expired without a plan
   * selected. - `OTHER` - The customer is suspended for an internal Google
   * reason (e.g. abuse or otherwise).
   *
   * @var string[]
   */
  public $suspensionReasons;
  protected $transferInfoType = SubscriptionTransferInfo::class;
  protected $transferInfoDataType = '';
  protected $trialSettingsType = SubscriptionTrialSettings::class;
  protected $trialSettingsDataType = '';

  /**
   * Read-only field that returns the current billing method for a subscription.
   *
   * @param string $billingMethod
   */
  public function setBillingMethod($billingMethod)
  {
    $this->billingMethod = $billingMethod;
  }
  /**
   * @return string
   */
  public function getBillingMethod()
  {
    return $this->billingMethod;
  }
  /**
   * The `creationTime` property is the date when subscription was created. It
   * is in milliseconds using the Epoch format. See an example Epoch converter.
   *
   * @param string $creationTime
   */
  public function setCreationTime($creationTime)
  {
    $this->creationTime = $creationTime;
  }
  /**
   * @return string
   */
  public function getCreationTime()
  {
    return $this->creationTime;
  }
  /**
   * Primary domain name of the customer
   *
   * @param string $customerDomain
   */
  public function setCustomerDomain($customerDomain)
  {
    $this->customerDomain = $customerDomain;
  }
  /**
   * @return string
   */
  public function getCustomerDomain()
  {
    return $this->customerDomain;
  }
  /**
   * This property will always be returned in a response as the unique
   * identifier generated by Google. In a request, this property can be either
   * the primary domain or the unique identifier generated by Google.
   *
   * @param string $customerId
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
  }
  /**
   * @return string
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }
  /**
   * Google-issued code (100 char max) for discounted pricing on subscription
   * plans. Deal code must be included in `insert` requests in order to receive
   * discounted rate. This property is optional, regular pricing applies if left
   * empty.
   *
   * @param string $dealCode
   */
  public function setDealCode($dealCode)
  {
    $this->dealCode = $dealCode;
  }
  /**
   * @return string
   */
  public function getDealCode()
  {
    return $this->dealCode;
  }
  /**
   * Identifies the resource as a Subscription. Value: `reseller#subscription`
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * The `plan` property is required. In this version of the API, the G Suite
   * plans are the flexible plan, annual commitment plan, and the 30-day free
   * trial plan. For more information about the API"s payment plans, see the API
   * concepts.
   *
   * @param SubscriptionPlan $plan
   */
  public function setPlan(SubscriptionPlan $plan)
  {
    $this->plan = $plan;
  }
  /**
   * @return SubscriptionPlan
   */
  public function getPlan()
  {
    return $this->plan;
  }
  /**
   * This is an optional property. This purchase order (PO) information is for
   * resellers to use for their company tracking usage. If a `purchaseOrderId`
   * value is given it appears in the API responses and shows up in the invoice.
   * The property accepts up to 80 plain text characters.
   *
   * @param string $purchaseOrderId
   */
  public function setPurchaseOrderId($purchaseOrderId)
  {
    $this->purchaseOrderId = $purchaseOrderId;
  }
  /**
   * @return string
   */
  public function getPurchaseOrderId()
  {
    return $this->purchaseOrderId;
  }
  /**
   * Renewal settings for the annual commitment plan. For more detailed
   * information, see renewal options in the administrator help center.
   *
   * @param RenewalSettings $renewalSettings
   */
  public function setRenewalSettings(RenewalSettings $renewalSettings)
  {
    $this->renewalSettings = $renewalSettings;
  }
  /**
   * @return RenewalSettings
   */
  public function getRenewalSettings()
  {
    return $this->renewalSettings;
  }
  /**
   * URL to customer's Subscriptions page in the Admin console. The read-only
   * URL is generated by the API service. This is used if your client
   * application requires the customer to complete a task using the
   * Subscriptions page in the Admin console.
   *
   * @param string $resourceUiUrl
   */
  public function setResourceUiUrl($resourceUiUrl)
  {
    $this->resourceUiUrl = $resourceUiUrl;
  }
  /**
   * @return string
   */
  public function getResourceUiUrl()
  {
    return $this->resourceUiUrl;
  }
  /**
   * This is a required property. The number and limit of user seat licenses in
   * the plan.
   *
   * @param Seats $seats
   */
  public function setSeats(Seats $seats)
  {
    $this->seats = $seats;
  }
  /**
   * @return Seats
   */
  public function getSeats()
  {
    return $this->seats;
  }
  /**
   * A required property. The `skuId` is a unique system identifier for a
   * product's SKU assigned to a customer in the subscription. For products and
   * SKUs available in this version of the API, see Product and SKU IDs.
   *
   * @param string $skuId
   */
  public function setSkuId($skuId)
  {
    $this->skuId = $skuId;
  }
  /**
   * @return string
   */
  public function getSkuId()
  {
    return $this->skuId;
  }
  /**
   * Read-only external display name for a product's SKU assigned to a customer
   * in the subscription. SKU names are subject to change at Google's
   * discretion. For products and SKUs available in this version of the API, see
   * Product and SKU IDs.
   *
   * @param string $skuName
   */
  public function setSkuName($skuName)
  {
    $this->skuName = $skuName;
  }
  /**
   * @return string
   */
  public function getSkuName()
  {
    return $this->skuName;
  }
  /**
   * This is an optional property.
   *
   * @param string $status
   */
  public function setStatus($status)
  {
    $this->status = $status;
  }
  /**
   * @return string
   */
  public function getStatus()
  {
    return $this->status;
  }
  /**
   * The `subscriptionId` is the subscription identifier and is unique for each
   * customer. This is a required property. Since a `subscriptionId` changes
   * when a subscription is updated, we recommend not using this ID as a key for
   * persistent data. Use the `subscriptionId` as described in retrieve all
   * reseller subscriptions.
   *
   * @param string $subscriptionId
   */
  public function setSubscriptionId($subscriptionId)
  {
    $this->subscriptionId = $subscriptionId;
  }
  /**
   * @return string
   */
  public function getSubscriptionId()
  {
    return $this->subscriptionId;
  }
  /**
   * Read-only field containing an enumerable of all the current suspension
   * reasons for a subscription. It is possible for a subscription to have many
   * concurrent, overlapping suspension reasons. A subscription's `STATUS` is
   * `SUSPENDED` until all pending suspensions are removed. Possible options
   * include: - `PENDING_TOS_ACCEPTANCE` - The customer has not logged in and
   * accepted the G Suite Resold Terms of Services. - `RENEWAL_WITH_TYPE_CANCEL`
   * - The customer's commitment ended and their service was cancelled at the
   * end of their term. - `RESELLER_INITIATED` - A manual suspension invoked by
   * a Reseller. - `TRIAL_ENDED` - The customer's trial expired without a plan
   * selected. - `OTHER` - The customer is suspended for an internal Google
   * reason (e.g. abuse or otherwise).
   *
   * @param string[] $suspensionReasons
   */
  public function setSuspensionReasons($suspensionReasons)
  {
    $this->suspensionReasons = $suspensionReasons;
  }
  /**
   * @return string[]
   */
  public function getSuspensionReasons()
  {
    return $this->suspensionReasons;
  }
  /**
   * Read-only transfer related information for the subscription. For more
   * information, see retrieve transferable subscriptions for a customer.
   *
   * @param SubscriptionTransferInfo $transferInfo
   */
  public function setTransferInfo(SubscriptionTransferInfo $transferInfo)
  {
    $this->transferInfo = $transferInfo;
  }
  /**
   * @return SubscriptionTransferInfo
   */
  public function getTransferInfo()
  {
    return $this->transferInfo;
  }
  /**
   * The G Suite annual commitment and flexible payment plans can be in a 30-day
   * free trial. For more information, see the API concepts.
   *
   * @param SubscriptionTrialSettings $trialSettings
   */
  public function setTrialSettings(SubscriptionTrialSettings $trialSettings)
  {
    $this->trialSettings = $trialSettings;
  }
  /**
   * @return SubscriptionTrialSettings
   */
  public function getTrialSettings()
  {
    return $this->trialSettings;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Subscription::class, 'Google_Service_Reseller_Subscription');
