<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Reseller;

class Customer extends \Google\Model
{
  /**
   * Customer type not known
   */
  public const CUSTOMER_TYPE_customerTypeUnspecified = 'customerTypeUnspecified';
  /**
   * Domained or domain-owning customers
   */
  public const CUSTOMER_TYPE_domain = 'domain';
  /**
   * Domainless or email-verified customers
   */
  public const CUSTOMER_TYPE_team = 'team';
  /**
   * Like the "Customer email" in the reseller tools, this email is the
   * secondary contact used if something happens to the customer's service such
   * as service outage or a security issue. This property is required when
   * creating a new "domain" customer and should not use the same domain as
   * `customerDomain`. The `alternateEmail` field is not necessary to create a
   * "team" customer.
   *
   * @var string
   */
  public $alternateEmail;
  /**
   * The customer's primary domain name string. `customerDomain` is required
   * when creating a new customer. Do not include the `www` prefix in the domain
   * when adding a customer.
   *
   * @var string
   */
  public $customerDomain;
  /**
   * Whether the customer's primary domain has been verified.
   *
   * @var bool
   */
  public $customerDomainVerified;
  /**
   * This property will always be returned in a response as the unique
   * identifier generated by Google. In a request, this property can be either
   * the primary domain or the unique identifier generated by Google.
   *
   * @var string
   */
  public $customerId;
  /**
   * Identifies the type of the customer. Acceptable values include: * `domain`:
   * Implies a domain-verified customer (default). * `team`: Implies an email-
   * verified customer. For more information, see [managed
   * teams](https://support.google.com/a/users/answer/9939479).
   *
   * @var string
   */
  public $customerType;
  /**
   * Identifies the resource as a customer. Value: `reseller#customer`
   *
   * @var string
   */
  public $kind;
  /**
   * Customer contact phone number. Must start with "+" followed by the country
   * code. The rest of the number can be contiguous numbers or respect the phone
   * local format conventions, but it must be a real phone number and not, for
   * example, "123". This field is silently ignored if invalid.
   *
   * @var string
   */
  public $phoneNumber;
  protected $postalAddressType = Address::class;
  protected $postalAddressDataType = '';
  protected $primaryAdminType = PrimaryAdmin::class;
  protected $primaryAdminDataType = '';
  /**
   * URL to customer's Admin console dashboard. The read-only URL is generated
   * by the API service. This is used if your client application requires the
   * customer to complete a task in the Admin console.
   *
   * @var string
   */
  public $resourceUiUrl;

  /**
   * Like the "Customer email" in the reseller tools, this email is the
   * secondary contact used if something happens to the customer's service such
   * as service outage or a security issue. This property is required when
   * creating a new "domain" customer and should not use the same domain as
   * `customerDomain`. The `alternateEmail` field is not necessary to create a
   * "team" customer.
   *
   * @param string $alternateEmail
   */
  public function setAlternateEmail($alternateEmail)
  {
    $this->alternateEmail = $alternateEmail;
  }
  /**
   * @return string
   */
  public function getAlternateEmail()
  {
    return $this->alternateEmail;
  }
  /**
   * The customer's primary domain name string. `customerDomain` is required
   * when creating a new customer. Do not include the `www` prefix in the domain
   * when adding a customer.
   *
   * @param string $customerDomain
   */
  public function setCustomerDomain($customerDomain)
  {
    $this->customerDomain = $customerDomain;
  }
  /**
   * @return string
   */
  public function getCustomerDomain()
  {
    return $this->customerDomain;
  }
  /**
   * Whether the customer's primary domain has been verified.
   *
   * @param bool $customerDomainVerified
   */
  public function setCustomerDomainVerified($customerDomainVerified)
  {
    $this->customerDomainVerified = $customerDomainVerified;
  }
  /**
   * @return bool
   */
  public function getCustomerDomainVerified()
  {
    return $this->customerDomainVerified;
  }
  /**
   * This property will always be returned in a response as the unique
   * identifier generated by Google. In a request, this property can be either
   * the primary domain or the unique identifier generated by Google.
   *
   * @param string $customerId
   */
  public function setCustomerId($customerId)
  {
    $this->customerId = $customerId;
  }
  /**
   * @return string
   */
  public function getCustomerId()
  {
    return $this->customerId;
  }
  /**
   * Identifies the type of the customer. Acceptable values include: * `domain`:
   * Implies a domain-verified customer (default). * `team`: Implies an email-
   * verified customer. For more information, see [managed
   * teams](https://support.google.com/a/users/answer/9939479).
   *
   * Accepted values: customerTypeUnspecified, domain, team
   *
   * @param self::CUSTOMER_TYPE_* $customerType
   */
  public function setCustomerType($customerType)
  {
    $this->customerType = $customerType;
  }
  /**
   * @return self::CUSTOMER_TYPE_*
   */
  public function getCustomerType()
  {
    return $this->customerType;
  }
  /**
   * Identifies the resource as a customer. Value: `reseller#customer`
   *
   * @param string $kind
   */
  public function setKind($kind)
  {
    $this->kind = $kind;
  }
  /**
   * @return string
   */
  public function getKind()
  {
    return $this->kind;
  }
  /**
   * Customer contact phone number. Must start with "+" followed by the country
   * code. The rest of the number can be contiguous numbers or respect the phone
   * local format conventions, but it must be a real phone number and not, for
   * example, "123". This field is silently ignored if invalid.
   *
   * @param string $phoneNumber
   */
  public function setPhoneNumber($phoneNumber)
  {
    $this->phoneNumber = $phoneNumber;
  }
  /**
   * @return string
   */
  public function getPhoneNumber()
  {
    return $this->phoneNumber;
  }
  /**
   * A customer's address information. Each field has a limit of 255 charcters.
   *
   * @param Address $postalAddress
   */
  public function setPostalAddress(Address $postalAddress)
  {
    $this->postalAddress = $postalAddress;
  }
  /**
   * @return Address
   */
  public function getPostalAddress()
  {
    return $this->postalAddress;
  }
  /**
   * The first admin details of the customer, present in case of TEAM customer.
   *
   * @param PrimaryAdmin $primaryAdmin
   */
  public function setPrimaryAdmin(PrimaryAdmin $primaryAdmin)
  {
    $this->primaryAdmin = $primaryAdmin;
  }
  /**
   * @return PrimaryAdmin
   */
  public function getPrimaryAdmin()
  {
    return $this->primaryAdmin;
  }
  /**
   * URL to customer's Admin console dashboard. The read-only URL is generated
   * by the API service. This is used if your client application requires the
   * customer to complete a task in the Admin console.
   *
   * @param string $resourceUiUrl
   */
  public function setResourceUiUrl($resourceUiUrl)
  {
    $this->resourceUiUrl = $resourceUiUrl;
  }
  /**
   * @return string
   */
  public function getResourceUiUrl()
  {
    return $this->resourceUiUrl;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Customer::class, 'Google_Service_Reseller_Customer');
