<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\IdentityToolkit;

class IdentitytoolkitRelyingpartyVerifyPhoneNumberResponse extends \Google\Model
{
  /**
   * @var string
   */
  public $expiresIn;
  /**
   * @var string
   */
  public $idToken;
  /**
   * @var bool
   */
  public $isNewUser;
  /**
   * @var string
   */
  public $localId;
  /**
   * @var string
   */
  public $phoneNumber;
  /**
   * @var string
   */
  public $refreshToken;
  /**
   * @var string
   */
  public $temporaryProof;
  /**
   * @var string
   */
  public $temporaryProofExpiresIn;
  /**
   * @var string
   */
  public $verificationProof;
  /**
   * @var string
   */
  public $verificationProofExpiresIn;

  /**
   * @param string $expiresIn
   */
  public function setExpiresIn($expiresIn)
  {
    $this->expiresIn = $expiresIn;
  }
  /**
   * @return string
   */
  public function getExpiresIn()
  {
    return $this->expiresIn;
  }
  /**
   * @param string $idToken
   */
  public function setIdToken($idToken)
  {
    $this->idToken = $idToken;
  }
  /**
   * @return string
   */
  public function getIdToken()
  {
    return $this->idToken;
  }
  /**
   * @param bool $isNewUser
   */
  public function setIsNewUser($isNewUser)
  {
    $this->isNewUser = $isNewUser;
  }
  /**
   * @return bool
   */
  public function getIsNewUser()
  {
    return $this->isNewUser;
  }
  /**
   * @param string $localId
   */
  public function setLocalId($localId)
  {
    $this->localId = $localId;
  }
  /**
   * @return string
   */
  public function getLocalId()
  {
    return $this->localId;
  }
  /**
   * @param string $phoneNumber
   */
  public function setPhoneNumber($phoneNumber)
  {
    $this->phoneNumber = $phoneNumber;
  }
  /**
   * @return string
   */
  public function getPhoneNumber()
  {
    return $this->phoneNumber;
  }
  /**
   * @param string $refreshToken
   */
  public function setRefreshToken($refreshToken)
  {
    $this->refreshToken = $refreshToken;
  }
  /**
   * @return string
   */
  public function getRefreshToken()
  {
    return $this->refreshToken;
  }
  /**
   * @param string $temporaryProof
   */
  public function setTemporaryProof($temporaryProof)
  {
    $this->temporaryProof = $temporaryProof;
  }
  /**
   * @return string
   */
  public function getTemporaryProof()
  {
    return $this->temporaryProof;
  }
  /**
   * @param string $temporaryProofExpiresIn
   */
  public function setTemporaryProofExpiresIn($temporaryProofExpiresIn)
  {
    $this->temporaryProofExpiresIn = $temporaryProofExpiresIn;
  }
  /**
   * @return string
   */
  public function getTemporaryProofExpiresIn()
  {
    return $this->temporaryProofExpiresIn;
  }
  /**
   * @param string $verificationProof
   */
  public function setVerificationProof($verificationProof)
  {
    $this->verificationProof = $verificationProof;
  }
  /**
   * @return string
   */
  public function getVerificationProof()
  {
    return $this->verificationProof;
  }
  /**
   * @param string $verificationProofExpiresIn
   */
  public function setVerificationProofExpiresIn($verificationProofExpiresIn)
  {
    $this->verificationProofExpiresIn = $verificationProofExpiresIn;
  }
  /**
   * @return string
   */
  public function getVerificationProofExpiresIn()
  {
    return $this->verificationProofExpiresIn;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(IdentitytoolkitRelyingpartyVerifyPhoneNumberResponse::class, 'Google_Service_IdentityToolkit_IdentitytoolkitRelyingpartyVerifyPhoneNumberResponse');
