<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\FirebaseAppHosting;

class RunService extends \Google\Model
{
  /**
   * Optional. The name of the Cloud Run [`service`](https://cloud.google.com/ru
   * n/docs/reference/rest/v2/projects.locations.services#resource:-service), in
   * the format: `projects/{project}/locations/{location}/services/{serviceId}`
   *
   * @var string
   */
  public $service;

  /**
   * Optional. The name of the Cloud Run [`service`](https://cloud.google.com/ru
   * n/docs/reference/rest/v2/projects.locations.services#resource:-service), in
   * the format: `projects/{project}/locations/{location}/services/{serviceId}`
   *
   * @param string $service
   */
  public function setService($service)
  {
    $this->service = $service;
  }
  /**
   * @return string
   */
  public function getService()
  {
    return $this->service;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(RunService::class, 'Google_Service_FirebaseAppHosting_RunService');
