<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DoubleClickBidManager;

class QueryMetadata extends \Google\Collection
{
  /**
   * Default value when format is not specified or is unknown in this version.
   */
  public const FORMAT_FORMAT_UNSPECIFIED = 'FORMAT_UNSPECIFIED';
  /**
   * CSV.
   */
  public const FORMAT_CSV = 'CSV';
  /**
   * Excel.
   */
  public const FORMAT_XLSX = 'XLSX';
  protected $collection_key = 'shareEmailAddress';
  protected $dataRangeType = DataRange::class;
  protected $dataRangeDataType = '';
  /**
   * The format of the report generated by the query.
   *
   * @var string
   */
  public $format;
  /**
   * Whether an email notification is sent to the query creator when a report
   * generated by the query is ready. This value is `false` by default.
   *
   * @var bool
   */
  public $sendNotification;
  /**
   * List of additional email addresses with which to share the query. If
   * send_notification is `true`, these email addresses will receive a
   * notification when a report generated by the query is ready. If these email
   * addresses are connected to Display & Video 360 users, the query will be
   * available to them in the Display & Video 360 interface.
   *
   * @var string[]
   */
  public $shareEmailAddress;
  /**
   * The display name of the query. This value will be used in the file name of
   * reports generated by the query.
   *
   * @var string
   */
  public $title;

  /**
   * The date range the report generated by the query will report on. This date
   * range will be defined by the time zone as used by the advertiser.
   *
   * @param DataRange $dataRange
   */
  public function setDataRange(DataRange $dataRange)
  {
    $this->dataRange = $dataRange;
  }
  /**
   * @return DataRange
   */
  public function getDataRange()
  {
    return $this->dataRange;
  }
  /**
   * The format of the report generated by the query.
   *
   * Accepted values: FORMAT_UNSPECIFIED, CSV, XLSX
   *
   * @param self::FORMAT_* $format
   */
  public function setFormat($format)
  {
    $this->format = $format;
  }
  /**
   * @return self::FORMAT_*
   */
  public function getFormat()
  {
    return $this->format;
  }
  /**
   * Whether an email notification is sent to the query creator when a report
   * generated by the query is ready. This value is `false` by default.
   *
   * @param bool $sendNotification
   */
  public function setSendNotification($sendNotification)
  {
    $this->sendNotification = $sendNotification;
  }
  /**
   * @return bool
   */
  public function getSendNotification()
  {
    return $this->sendNotification;
  }
  /**
   * List of additional email addresses with which to share the query. If
   * send_notification is `true`, these email addresses will receive a
   * notification when a report generated by the query is ready. If these email
   * addresses are connected to Display & Video 360 users, the query will be
   * available to them in the Display & Video 360 interface.
   *
   * @param string[] $shareEmailAddress
   */
  public function setShareEmailAddress($shareEmailAddress)
  {
    $this->shareEmailAddress = $shareEmailAddress;
  }
  /**
   * @return string[]
   */
  public function getShareEmailAddress()
  {
    return $this->shareEmailAddress;
  }
  /**
   * The display name of the query. This value will be used in the file name of
   * reports generated by the query.
   *
   * @param string $title
   */
  public function setTitle($title)
  {
    $this->title = $title;
  }
  /**
   * @return string
   */
  public function getTitle()
  {
    return $this->title;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(QueryMetadata::class, 'Google_Service_DoubleClickBidManager_QueryMetadata');
