<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Docs;

class SuggestedInlineObjectProperties extends \Google\Model
{
  protected $inlineObjectPropertiesType = InlineObjectProperties::class;
  protected $inlineObjectPropertiesDataType = '';
  protected $inlineObjectPropertiesSuggestionStateType = InlineObjectPropertiesSuggestionState::class;
  protected $inlineObjectPropertiesSuggestionStateDataType = '';

  /**
   * An InlineObjectProperties that only includes the changes made in this
   * suggestion. This can be used along with the
   * inline_object_properties_suggestion_state to see which fields have changed
   * and their new values.
   *
   * @param InlineObjectProperties $inlineObjectProperties
   */
  public function setInlineObjectProperties(InlineObjectProperties $inlineObjectProperties)
  {
    $this->inlineObjectProperties = $inlineObjectProperties;
  }
  /**
   * @return InlineObjectProperties
   */
  public function getInlineObjectProperties()
  {
    return $this->inlineObjectProperties;
  }
  /**
   * A mask that indicates which of the fields on the base
   * InlineObjectProperties have been changed in this suggestion.
   *
   * @param InlineObjectPropertiesSuggestionState $inlineObjectPropertiesSuggestionState
   */
  public function setInlineObjectPropertiesSuggestionState(InlineObjectPropertiesSuggestionState $inlineObjectPropertiesSuggestionState)
  {
    $this->inlineObjectPropertiesSuggestionState = $inlineObjectPropertiesSuggestionState;
  }
  /**
   * @return InlineObjectPropertiesSuggestionState
   */
  public function getInlineObjectPropertiesSuggestionState()
  {
    return $this->inlineObjectPropertiesSuggestionState;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(SuggestedInlineObjectProperties::class, 'Google_Service_Docs_SuggestedInlineObjectProperties');
