<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\DiscoveryEngine;

class GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment extends \Google\Model
{
  /**
   * Unspecified attribution type.
   */
  public const ATTRIBUTION_TYPE_ATTRIBUTION_TYPE_UNSPECIFIED = 'ATTRIBUTION_TYPE_UNSPECIFIED';
  /**
   * The attachment data is from the corpus.
   */
  public const ATTRIBUTION_TYPE_CORPUS = 'CORPUS';
  /**
   * The attachment data is generated by the model through code generation.
   */
  public const ATTRIBUTION_TYPE_GENERATED = 'GENERATED';
  /**
   * Output only. The attribution type of the blob.
   *
   * @var string
   */
  public $attributionType;
  protected $dataType = GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob::class;
  protected $dataDataType = '';

  /**
   * Output only. The attribution type of the blob.
   *
   * Accepted values: ATTRIBUTION_TYPE_UNSPECIFIED, CORPUS, GENERATED
   *
   * @param self::ATTRIBUTION_TYPE_* $attributionType
   */
  public function setAttributionType($attributionType)
  {
    $this->attributionType = $attributionType;
  }
  /**
   * @return self::ATTRIBUTION_TYPE_*
   */
  public function getAttributionType()
  {
    return $this->attributionType;
  }
  /**
   * Output only. The mime type and data of the blob.
   *
   * @param GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob $data
   */
  public function setData(GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob $data)
  {
    $this->data = $data;
  }
  /**
   * @return GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachmentBlob
   */
  public function getData()
  {
    return $this->data;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment::class, 'Google_Service_DiscoveryEngine_GoogleCloudDiscoveryengineV1alphaAnswerBlobAttachment');
