<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Dataflow;

class InstructionOutput extends \Google\Model
{
  /**
   * The codec to use to encode data being written via this output.
   *
   * @var array[]
   */
  public $codec;
  /**
   * The user-provided name of this output.
   *
   * @var string
   */
  public $name;
  /**
   * For system-generated byte and mean byte metrics, certain instructions
   * should only report the key size.
   *
   * @var bool
   */
  public $onlyCountKeyBytes;
  /**
   * For system-generated byte and mean byte metrics, certain instructions
   * should only report the value size.
   *
   * @var bool
   */
  public $onlyCountValueBytes;
  /**
   * System-defined name for this output in the original workflow graph. Outputs
   * that do not contribute to an original instruction do not set this.
   *
   * @var string
   */
  public $originalName;
  /**
   * System-defined name of this output. Unique across the workflow.
   *
   * @var string
   */
  public $systemName;

  /**
   * The codec to use to encode data being written via this output.
   *
   * @param array[] $codec
   */
  public function setCodec($codec)
  {
    $this->codec = $codec;
  }
  /**
   * @return array[]
   */
  public function getCodec()
  {
    return $this->codec;
  }
  /**
   * The user-provided name of this output.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * For system-generated byte and mean byte metrics, certain instructions
   * should only report the key size.
   *
   * @param bool $onlyCountKeyBytes
   */
  public function setOnlyCountKeyBytes($onlyCountKeyBytes)
  {
    $this->onlyCountKeyBytes = $onlyCountKeyBytes;
  }
  /**
   * @return bool
   */
  public function getOnlyCountKeyBytes()
  {
    return $this->onlyCountKeyBytes;
  }
  /**
   * For system-generated byte and mean byte metrics, certain instructions
   * should only report the value size.
   *
   * @param bool $onlyCountValueBytes
   */
  public function setOnlyCountValueBytes($onlyCountValueBytes)
  {
    $this->onlyCountValueBytes = $onlyCountValueBytes;
  }
  /**
   * @return bool
   */
  public function getOnlyCountValueBytes()
  {
    return $this->onlyCountValueBytes;
  }
  /**
   * System-defined name for this output in the original workflow graph. Outputs
   * that do not contribute to an original instruction do not set this.
   *
   * @param string $originalName
   */
  public function setOriginalName($originalName)
  {
    $this->originalName = $originalName;
  }
  /**
   * @return string
   */
  public function getOriginalName()
  {
    return $this->originalName;
  }
  /**
   * System-defined name of this output. Unique across the workflow.
   *
   * @param string $systemName
   */
  public function setSystemName($systemName)
  {
    $this->systemName = $systemName;
  }
  /**
   * @return string
   */
  public function getSystemName()
  {
    return $this->systemName;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(InstructionOutput::class, 'Google_Service_Dataflow_InstructionOutput');
