<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudResourceManager;

class TagHold extends \Google\Model
{
  /**
   * Output only. The time this TagHold was created.
   *
   * @var string
   */
  public $createTime;
  /**
   * Optional. A URL where an end user can learn more about removing this hold.
   * E.g. `https://cloud.google.com/resource-manager/docs/tags/tags-creating-
   * and-managing`
   *
   * @var string
   */
  public $helpLink;
  /**
   * Required. The name of the resource where the TagValue is being used. Must
   * be less than 200 characters. E.g.
   * `//compute.googleapis.com/compute/projects/myproject/regions/us-
   * east-1/instanceGroupManagers/instance-group`
   *
   * @var string
   */
  public $holder;
  /**
   * Output only. The resource name of a TagHold. This is a String of the form:
   * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}` (e.g.
   * `tagValues/123/tagHolds/456`). This resource name is generated by the
   * server.
   *
   * @var string
   */
  public $name;
  /**
   * Optional. An optional string representing the origin of this request. This
   * field should include human-understandable information to distinguish
   * origins from each other. Must be less than 200 characters. E.g.
   * `migs-35678234`
   *
   * @var string
   */
  public $origin;

  /**
   * Output only. The time this TagHold was created.
   *
   * @param string $createTime
   */
  public function setCreateTime($createTime)
  {
    $this->createTime = $createTime;
  }
  /**
   * @return string
   */
  public function getCreateTime()
  {
    return $this->createTime;
  }
  /**
   * Optional. A URL where an end user can learn more about removing this hold.
   * E.g. `https://cloud.google.com/resource-manager/docs/tags/tags-creating-
   * and-managing`
   *
   * @param string $helpLink
   */
  public function setHelpLink($helpLink)
  {
    $this->helpLink = $helpLink;
  }
  /**
   * @return string
   */
  public function getHelpLink()
  {
    return $this->helpLink;
  }
  /**
   * Required. The name of the resource where the TagValue is being used. Must
   * be less than 200 characters. E.g.
   * `//compute.googleapis.com/compute/projects/myproject/regions/us-
   * east-1/instanceGroupManagers/instance-group`
   *
   * @param string $holder
   */
  public function setHolder($holder)
  {
    $this->holder = $holder;
  }
  /**
   * @return string
   */
  public function getHolder()
  {
    return $this->holder;
  }
  /**
   * Output only. The resource name of a TagHold. This is a String of the form:
   * `tagValues/{tag-value-id}/tagHolds/{tag-hold-id}` (e.g.
   * `tagValues/123/tagHolds/456`). This resource name is generated by the
   * server.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Optional. An optional string representing the origin of this request. This
   * field should include human-understandable information to distinguish
   * origins from each other. Must be less than 200 characters. E.g.
   * `migs-35678234`
   *
   * @param string $origin
   */
  public function setOrigin($origin)
  {
    $this->origin = $origin;
  }
  /**
   * @return string
   */
  public function getOrigin()
  {
    return $this->origin;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(TagHold::class, 'Google_Service_CloudResourceManager_TagHold');
