<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\CloudDataplex;

class GoogleCloudDataplexV1EnvironmentSessionSpec extends \Google\Model
{
  /**
   * Optional. If True, this causes sessions to be pre-created and available for
   * faster startup to enable interactive exploration use-cases. This defaults
   * to False to avoid additional billed charges. These can only be set to True
   * for the environment with name set to "default", and with default
   * configuration.
   *
   * @var bool
   */
  public $enableFastStartup;
  /**
   * Optional. The idle time configuration of the session. The session will be
   * auto-terminated at the end of this period.
   *
   * @var string
   */
  public $maxIdleDuration;

  /**
   * Optional. If True, this causes sessions to be pre-created and available for
   * faster startup to enable interactive exploration use-cases. This defaults
   * to False to avoid additional billed charges. These can only be set to True
   * for the environment with name set to "default", and with default
   * configuration.
   *
   * @param bool $enableFastStartup
   */
  public function setEnableFastStartup($enableFastStartup)
  {
    $this->enableFastStartup = $enableFastStartup;
  }
  /**
   * @return bool
   */
  public function getEnableFastStartup()
  {
    return $this->enableFastStartup;
  }
  /**
   * Optional. The idle time configuration of the session. The session will be
   * auto-terminated at the end of this period.
   *
   * @param string $maxIdleDuration
   */
  public function setMaxIdleDuration($maxIdleDuration)
  {
    $this->maxIdleDuration = $maxIdleDuration;
  }
  /**
   * @return string
   */
  public function getMaxIdleDuration()
  {
    return $this->maxIdleDuration;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudDataplexV1EnvironmentSessionSpec::class, 'Google_Service_CloudDataplex_GoogleCloudDataplexV1EnvironmentSessionSpec');
