<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\Classroom;

class Topic extends \Google\Model
{
  /**
   * Identifier of the course. Read-only.
   *
   * @var string
   */
  public $courseId;
  /**
   * The name of the topic, generated by the user. Leading and trailing
   * whitespaces, if any, are trimmed. Also, multiple consecutive whitespaces
   * are collapsed into one inside the name. The result must be a non-empty
   * string. Topic names are case sensitive, and must be no longer than 100
   * characters.
   *
   * @var string
   */
  public $name;
  /**
   * Unique identifier for the topic. Read-only.
   *
   * @var string
   */
  public $topicId;
  /**
   * The time the topic was last updated by the system. Read-only.
   *
   * @var string
   */
  public $updateTime;

  /**
   * Identifier of the course. Read-only.
   *
   * @param string $courseId
   */
  public function setCourseId($courseId)
  {
    $this->courseId = $courseId;
  }
  /**
   * @return string
   */
  public function getCourseId()
  {
    return $this->courseId;
  }
  /**
   * The name of the topic, generated by the user. Leading and trailing
   * whitespaces, if any, are trimmed. Also, multiple consecutive whitespaces
   * are collapsed into one inside the name. The result must be a non-empty
   * string. Topic names are case sensitive, and must be no longer than 100
   * characters.
   *
   * @param string $name
   */
  public function setName($name)
  {
    $this->name = $name;
  }
  /**
   * @return string
   */
  public function getName()
  {
    return $this->name;
  }
  /**
   * Unique identifier for the topic. Read-only.
   *
   * @param string $topicId
   */
  public function setTopicId($topicId)
  {
    $this->topicId = $topicId;
  }
  /**
   * @return string
   */
  public function getTopicId()
  {
    return $this->topicId;
  }
  /**
   * The time the topic was last updated by the system. Read-only.
   *
   * @param string $updateTime
   */
  public function setUpdateTime($updateTime)
  {
    $this->updateTime = $updateTime;
  }
  /**
   * @return string
   */
  public function getUpdateTime()
  {
    return $this->updateTime;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(Topic::class, 'Google_Service_Classroom_Topic');
