<?php
/*
 * Copyright 2014 Google Inc.
 *
 * Licensed under the Apache License, Version 2.0 (the "License"); you may not
 * use this file except in compliance with the License. You may obtain a copy of
 * the License at
 *
 * http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS, WITHOUT
 * WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied. See the
 * License for the specific language governing permissions and limitations under
 * the License.
 */

namespace Google\Service\APIhub;

class GoogleCloudApihubV1APIMetadata extends \Google\Collection
{
  protected $collection_key = 'versions';
  protected $apiType = GoogleCloudApihubV1Api::class;
  protected $apiDataType = '';
  /**
   * Optional. Timestamp indicating when the API was created at the source.
   *
   * @var string
   */
  public $originalCreateTime;
  /**
   * Optional. The unique identifier of the API in the system where it was
   * originally created.
   *
   * @var string
   */
  public $originalId;
  /**
   * Required. Timestamp indicating when the API was last updated at the source.
   *
   * @var string
   */
  public $originalUpdateTime;
  protected $versionsType = GoogleCloudApihubV1VersionMetadata::class;
  protected $versionsDataType = 'array';

  /**
   * Required. The API resource to be pushed to Hub's collect layer. The ID of
   * the API resource will be generated by Hub to ensure uniqueness across all
   * APIs across systems.
   *
   * @param GoogleCloudApihubV1Api $api
   */
  public function setApi(GoogleCloudApihubV1Api $api)
  {
    $this->api = $api;
  }
  /**
   * @return GoogleCloudApihubV1Api
   */
  public function getApi()
  {
    return $this->api;
  }
  /**
   * Optional. Timestamp indicating when the API was created at the source.
   *
   * @param string $originalCreateTime
   */
  public function setOriginalCreateTime($originalCreateTime)
  {
    $this->originalCreateTime = $originalCreateTime;
  }
  /**
   * @return string
   */
  public function getOriginalCreateTime()
  {
    return $this->originalCreateTime;
  }
  /**
   * Optional. The unique identifier of the API in the system where it was
   * originally created.
   *
   * @param string $originalId
   */
  public function setOriginalId($originalId)
  {
    $this->originalId = $originalId;
  }
  /**
   * @return string
   */
  public function getOriginalId()
  {
    return $this->originalId;
  }
  /**
   * Required. Timestamp indicating when the API was last updated at the source.
   *
   * @param string $originalUpdateTime
   */
  public function setOriginalUpdateTime($originalUpdateTime)
  {
    $this->originalUpdateTime = $originalUpdateTime;
  }
  /**
   * @return string
   */
  public function getOriginalUpdateTime()
  {
    return $this->originalUpdateTime;
  }
  /**
   * Optional. The list of versions present in an API resource.
   *
   * @param GoogleCloudApihubV1VersionMetadata[] $versions
   */
  public function setVersions($versions)
  {
    $this->versions = $versions;
  }
  /**
   * @return GoogleCloudApihubV1VersionMetadata[]
   */
  public function getVersions()
  {
    return $this->versions;
  }
}

// Adding a class alias for backwards compatibility with the previous class name.
class_alias(GoogleCloudApihubV1APIMetadata::class, 'Google_Service_APIhub_GoogleCloudApihubV1APIMetadata');
